#include <iostream>
#include <vector>
#include <chrono>

using namespace std;

// Go from 2D index to 1D index
inline int index(int a, int b, int n) {
    return a*(n + 1) + b;
}

int main() {

    // Large prime to reduce the size of numbers
    const int p = 1000000007;

    int n;
    cin >> n;

    if (n == 1) {
        cout << 1 << endl;
        return 0;
    }

    // Start timer to check program speed
    auto start = chrono::high_resolution_clock::now();

    // Initialize table that counts partitions.
    // Index 1 (i) indicates size of partitioned set.
    // Index 2 (k) indicates size of set in partition.
    // Content indicates the number of sets of size k in partition of set of size i.
    vector<long int> l((n + 1)*(n + 1));
    
    // Initialize table
    l[index(1, 1, n)] = 1;

    for (int i = 2; i < n + 1; i++) {
        for (int k = 2; k < n+1; k++) {
            // Recursive relation to calculate size in next cell
            l[index(i, k, n)] = (l[index(i - 1, k, n)] * (k - 1) + l[index(i - 1, k - 1, n)])%p;
            if (l[index(i, k , n)] == 0) break;
        }
    }

    // Zn is final result
    int Zn = 0;

    for (int i = 0; i < n; i++)
        Zn = (Zn + i*l[index(n - 1, i, n)]) % p;
    
    cout << Zn << endl;

    // Gives time taken for program execution in milliseconds.
    auto end = chrono::high_resolution_clock::now();
    auto duration = chrono::duration_cast<chrono::milliseconds>(end - start);
    // cout << duration.count() << endl;

    return 0;
}
